/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.iteminfo.model.special;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.devtech.arrp.json.iteminfo.model.JItemModel;
import net.devtech.arrp.json.iteminfo.model.special.JModelHead;
import net.devtech.arrp.json.iteminfo.model.special.JModelShield;

public class JModelSpecial
extends JItemModel {
    public static final String TYPE = "minecraft:special";
    public static final MapCodec<JModelSpecial> CODEC = RecordCodecBuilder.mapCodec(function -> function.group((App)Codec.STRING.fieldOf("base").forGetter(JModelSpecial::getBase), (App)JItemModel.CODEC.fieldOf("model").forGetter(JModelSpecial::getModel), (App)Codec.STRING.fieldOf("special_type").forGetter(JModelSpecial::getSpecialType)).apply((Applicative)function, JModelSpecial::new));
    private String base;
    private JItemModel model;
    private String specialType;

    public JModelSpecial() {
        super(TYPE);
    }

    protected JModelSpecial(String specialType) {
        super(TYPE);
        this.specialType = specialType;
    }

    protected JModelSpecial(String base, JItemModel model, String specialType) {
        super(TYPE);
        this.base = base;
        this.model = model;
        this.specialType = specialType;
    }

    public static JModelSpecial specialModel(String base, JItemModel special) {
        return new JModelSpecial().base(base).model(special);
    }

    public static JModelShield shield() {
        return new JModelShield();
    }

    public String getSpecialType() {
        return this.specialType;
    }

    public static JModelHead head() {
        return new JModelHead();
    }

    public JModelSpecial base(String base) {
        this.base = base;
        return this;
    }

    public JModelSpecial model(JItemModel model) {
        this.model = model;
        return this;
    }

    public String getBase() {
        return this.base;
    }

    public JItemModel getModel() {
        return this.model;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (this.base != null) {
            json.addProperty("base", this.base);
        }
        if (this.model != null) {
            json.add("model", (JsonElement)this.model.toJson());
        }
        return json;
    }

    @Override
    public JModelSpecial clone() {
        JModelSpecial cloned = new JModelSpecial();
        cloned.base = this.base;
        cloned.model = this.model != null ? this.model.clone() : null;
        return cloned;
    }

    static {
        JItemModel.register(TYPE, (MapCodec<? extends JItemModel>)CODEC.xmap(m -> {
            m.type = TYPE;
            return m;
        }, m -> m));
    }
}

