/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JEntry;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JRoll;

public class JPool
implements Cloneable {
    public static final Codec<JPool> CODEC = RecordCodecBuilder.create(i -> i.group((App)JCondition.CODEC.listOf().optionalFieldOf("conditions").forGetter(p -> Optional.ofNullable(p.conditions)), (App)JFunction.CODEC.listOf().optionalFieldOf("functions").forGetter(p -> Optional.ofNullable(p.functions)), (App)JEntry.CODEC.listOf().optionalFieldOf("entries").forGetter(p -> Optional.ofNullable(p.entries)), (App)Codec.either((Codec)Codec.INT, JRoll.CODEC).optionalFieldOf("rolls").forGetter(p -> Optional.ofNullable(JPool.rollsEither(p))), (App)Codec.either((Codec)Codec.INT, JRoll.CODEC).optionalFieldOf("bonus_rolls").forGetter(p -> Optional.ofNullable(JPool.bonusEither(p)))).apply((Applicative)i, (ocond, ofunc, oent, orolls, obonus) -> {
        JPool p = new JPool();
        p.conditions = ocond.orElse(null);
        p.functions = ofunc.orElse(null);
        p.entries = oent.orElse(null);
        orolls.ifPresent(e -> {
            if (e.left().isPresent()) {
                p.rolls = (Integer)e.left().get();
            } else {
                p.roll = (JRoll)e.right().get();
            }
        });
        obonus.ifPresent(e -> {
            if (e.left().isPresent()) {
                p.bonus_rolls = (Integer)e.left().get();
            } else {
                p.bonus_roll = (JRoll)e.right().get();
            }
        });
        return p;
    }));
    private List<JCondition> conditions;
    private List<JFunction> functions;
    private List<JEntry> entries;
    private Integer rolls;
    private JRoll roll;
    private Integer bonus_rolls;
    private JRoll bonus_roll;

    private static Either<Integer, JRoll> rollsEither(JPool p) {
        if (p.roll != null) {
            return Either.right((Object)p.roll);
        }
        if (p.rolls != null) {
            return Either.left((Object)p.rolls);
        }
        return null;
    }

    private static Either<Integer, JRoll> bonusEither(JPool p) {
        if (p.bonus_roll != null) {
            return Either.right((Object)p.bonus_roll);
        }
        if (p.bonus_rolls != null) {
            return Either.left((Object)p.bonus_rolls);
        }
        return null;
    }

    public JPool entry(JEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList<JEntry>(1);
        }
        this.entries.add(entry);
        return this;
    }

    public JPool condition(JCondition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<JCondition>(1);
        }
        this.conditions.add(condition);
        return this;
    }

    public JPool function(JFunction function) {
        if (this.functions == null) {
            this.functions = new ArrayList<JFunction>(1);
        }
        this.functions.add(function);
        return this;
    }

    public JPool rolls(Integer rolls) {
        this.rolls = rolls;
        return this;
    }

    public JPool rolls(JRoll roll) {
        this.roll = roll;
        return this;
    }

    public JPool bonus(Integer bonus_rolls) {
        this.bonus_rolls = bonus_rolls;
        return this;
    }

    public JPool bonus(JRoll bonus_roll) {
        this.bonus_roll = bonus_roll;
        return this;
    }

    public JPool clone() {
        try {
            return (JPool)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public static class Serializer
    implements JsonSerializer<JPool> {
        public JsonElement serialize(JPool src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            if (src.conditions != null) {
                obj.add("conditions", context.serialize(src.conditions));
            }
            if (src.functions != null) {
                obj.add("functions", context.serialize(src.functions));
            }
            if (src.entries != null) {
                obj.add("entries", context.serialize(src.entries));
            }
            if (src.rolls != null) {
                obj.addProperty("rolls", (Number)src.rolls);
            }
            if (src.roll != null) {
                obj.add("rolls", context.serialize((Object)src.roll));
            }
            if (src.bonus_roll != null) {
                obj.add("bonus_rolls", context.serialize((Object)src.bonus_roll));
            }
            if (src.bonus_rolls != null) {
                obj.addProperty("bonus_rolls", (Number)src.bonus_rolls);
            }
            return obj;
        }
    }
}

