/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;

public class JIngredient
implements Cloneable {
    public static final Codec<JIngredient> CODEC = new Codec<JIngredient>(){

        public <T> DataResult<T> encode(JIngredient v, DynamicOps<T> ops, T prefix) {
            if (v.fabricCustom != null) {
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)v.fabricCustom).convert(ops).getValue());
            }
            if (v.item != null) {
                return ops.mapBuilder().add(ops.createString("item"), Identifier.CODEC.encodeStart(ops, (Object)v.item).getOrThrow()).build(prefix);
            }
            if (v.tag != null) {
                return ops.mapBuilder().add(ops.createString("tag"), Identifier.CODEC.encodeStart(ops, (Object)v.tag).getOrThrow()).build(prefix);
            }
            return DataResult.error(() -> "JIngredient: empty; set item(), tag(), or fabricCustom()");
        }

        public <T> DataResult<Pair<JIngredient, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Ingredient must be an object");
            }
            JsonObject obj = el.getAsJsonObject();
            JsonElement ft = obj.get("fabric:type");
            if (ft != null && ft.isJsonPrimitive() && ft.getAsJsonPrimitive().isString()) {
                JIngredient ing = new JIngredient();
                ing.fabricCustom = obj.deepCopy();
                return DataResult.success((Object)Pair.of((Object)ing, input));
            }
            JsonElement itemEl = obj.get("item");
            JsonElement tagEl = obj.get("tag");
            if (itemEl != null) {
                Optional id = Identifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)itemEl).result();
                return id.map(identifier -> DataResult.success((Object)Pair.of((Object)JIngredient.ingredient().item((Identifier)identifier), (Object)input))).orElseGet(() -> DataResult.error(() -> "Ingredient: bad 'item'"));
            }
            if (tagEl != null) {
                Optional id = Identifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)tagEl).result();
                return id.map(identifier -> DataResult.success((Object)Pair.of((Object)JIngredient.ingredient().tag((Identifier)identifier), (Object)input))).orElseGet(() -> DataResult.error(() -> "Ingredient: bad 'tag'"));
            }
            return DataResult.error(() -> "Ingredient: expected 'item', 'tag', or 'fabric:type'");
        }
    };
    protected Identifier item;
    protected Identifier tag;
    protected List<JIngredient> ingredients;
    private JsonObject fabricCustom;

    JIngredient() {
    }

    public JIngredient(Identifier item, Identifier tag, List<JIngredient> ingredients) {
        this.item = item;
        this.tag = tag;
        this.ingredients = ingredients;
    }

    public static JIngredient ingredient() {
        return new JIngredient();
    }

    public boolean isFabricCustom() {
        return this.fabricCustom != null;
    }

    public JIngredient fabricCustom(Identifier type, Consumer<JsonObject> data) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fabric:type", type.toString());
        if (data != null) {
            data.accept(obj);
        }
        this.fabricCustom = obj;
        this.item = null;
        this.tag = null;
        return this;
    }

    public JIngredient item(Item item) {
        return this.item(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public JIngredient item(Identifier id) {
        if (this.isDefined()) {
            return this.add(JIngredient.ingredient().item(id));
        }
        this.item = id;
        return this;
    }

    public JIngredient tag(Identifier tag) {
        if (this.isDefined()) {
            return this.add(JIngredient.ingredient().tag(tag));
        }
        this.tag = tag;
        return this;
    }

    public JIngredient add(JIngredient ingredient) {
        if (this.ingredients == null) {
            ArrayList<JIngredient> ingredients = new ArrayList<JIngredient>();
            if (this.isDefined()) {
                ingredients.add(this.clone());
            }
            this.ingredients = ingredients;
        }
        this.ingredients.add(ingredient);
        return this;
    }

    private boolean isDefined() {
        return this.item != null || this.tag != null;
    }

    public JIngredient clone() {
        try {
            return (JIngredient)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public Identifier getItem() {
        return this.item;
    }

    public Identifier getTag() {
        return this.tag;
    }

    public List<JIngredient> getIngredients() {
        return this.ingredients;
    }
}

