/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.devtech.arrp.json.codec.Codecs;
import net.devtech.arrp.json.recipe.JIngredient;

public class JKeys
implements Cloneable {
    protected final Map<String, JIngredient> keys = new HashMap<String, JIngredient>(9, 1.0f);
    protected final Map<String, List<JIngredient>> acceptableKeys = new HashMap<String, List<JIngredient>>();
    public static final Codec<JKeys> CODEC = Codec.unboundedMap((Codec)Codec.STRING, Codecs.oneOrList(JIngredient.CODEC)).xmap(JKeys::fromMap, JKeys::toMap).validate(JKeys::validateUnique);

    JKeys() {
    }

    public static JKeys keys() {
        return new JKeys();
    }

    public JKeys key(String key, JIngredient value) {
        this.keys.put(key, value);
        return this;
    }

    public JKeys keyAny(String key, List<JIngredient> values) {
        this.acceptableKeys.put(key, values);
        return this;
    }

    protected JKeys clone() {
        try {
            return (JKeys)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static JKeys fromMap(Map<String, List<JIngredient>> in) {
        JKeys out = new JKeys();
        for (Map.Entry<String, List<JIngredient>> e : in.entrySet()) {
            List<JIngredient> list = e.getValue();
            if (list == null || list.isEmpty()) continue;
            if (list.size() == 1) {
                out.keys.put(e.getKey(), list.getFirst());
                continue;
            }
            out.acceptableKeys.put(e.getKey(), List.copyOf(list));
        }
        return out;
    }

    private Map<String, List<JIngredient>> toMap() {
        LinkedHashMap<String, List<JIngredient>> out = new LinkedHashMap<String, List<JIngredient>>();
        for (Map.Entry<String, JIngredient> entry : this.keys.entrySet()) {
            out.put(entry.getKey(), List.of(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.acceptableKeys.entrySet()) {
            out.put(entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return out;
    }

    private static DataResult<JKeys> validateUnique(JKeys k) {
        for (String s : k.keys.keySet()) {
            if (!k.acceptableKeys.containsKey(s)) continue;
            return DataResult.error(() -> "JKeys: key '" + s + "' present as both single and list");
        }
        return DataResult.success((Object)k);
    }

    public static class Serializer
    implements JsonSerializer<JKeys> {
        public JsonElement serialize(JKeys src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            src.keys.forEach((key, ingredient) -> object.add(key, context.serialize(ingredient)));
            src.acceptableKeys.forEach((key, acceptableIngredients) -> object.add(key, context.serialize(acceptableIngredients)));
            return object;
        }
    }
}

