/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.devtech.arrp.json.codec.Codecs;
import net.devtech.arrp.json.recipe.JBlastingRecipe;
import net.devtech.arrp.json.recipe.JCampfireRecipe;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JResult;
import net.devtech.arrp.json.recipe.JShapedRecipe;
import net.devtech.arrp.json.recipe.JShapelessRecipe;
import net.devtech.arrp.json.recipe.JSmeltingRecipe;
import net.devtech.arrp.json.recipe.JSmithingTransformRecipe;
import net.devtech.arrp.json.recipe.JSmithingTrimRecipe;
import net.devtech.arrp.json.recipe.JSmokingRecipe;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.devtech.arrp.json.recipe.JStonecuttingRecipe;
import net.minecraft.resources.Identifier;

public abstract class JRecipe
implements Cloneable {
    private static final Map<Identifier, Codec<? extends JRecipe>> REGISTRY = new ConcurrentHashMap<Identifier, Codec<? extends JRecipe>>();
    public static final Codec<JRecipe> CODEC = Codecs.tagged("type", JRecipe::getType, REGISTRY::get, Identifier.CODEC);
    protected final Identifier type;
    protected String group;

    JRecipe(Identifier type) {
        this.type = type;
    }

    public static <R extends JRecipe> void register(Identifier type, Codec<R> codec) {
        REGISTRY.put(type, codec);
    }

    @Deprecated
    public static JSmithingTransformRecipe smithing(JIngredient base, JIngredient addition, JIngredient template, JResult result) {
        return JRecipe.smithingTransform(base, addition, template, result);
    }

    public static JSmithingTransformRecipe smithingTransform(JIngredient base, JIngredient addition, JIngredient template, JResult result) {
        return new JSmithingTransformRecipe(base, addition, template, result);
    }

    public static JSmithingTrimRecipe smithingTrim(JIngredient addition, JIngredient template) {
        return new JSmithingTrimRecipe(JIngredient.ingredient().tag(Identifier.withDefaultNamespace((String)"trimmable_armor")), addition, template);
    }

    public static JSmithingTrimRecipe smithingTrim(JIngredient base, JIngredient addition, JIngredient template) {
        return new JSmithingTrimRecipe(base, addition, template);
    }

    public static JStonecuttingRecipe stonecutting(JIngredient ingredient, JStackedResult result) {
        return new JStonecuttingRecipe(ingredient, result);
    }

    public static JShapedRecipe shaped(JPattern pattern, JKeys keys, JResult result) {
        return new JShapedRecipe(pattern, keys, result);
    }

    public static JShapelessRecipe shapeless(JIngredients ingredients, JResult result) {
        return new JShapelessRecipe(result, ingredients);
    }

    public static JBlastingRecipe blasting(JIngredient ingredient, JResult result) {
        return new JBlastingRecipe(ingredient, result);
    }

    public static JSmeltingRecipe smelting(JIngredient ingredient, JResult result) {
        return new JSmeltingRecipe(ingredient, result);
    }

    public static JCampfireRecipe campfire(JIngredient ingredient, JResult result) {
        return new JCampfireRecipe(ingredient, result);
    }

    public static JSmokingRecipe smoking(JIngredient ingredient, JResult result) {
        return new JSmokingRecipe(ingredient, result);
    }

    public JRecipe group(String group) {
        this.group = group;
        return this;
    }

    public Identifier getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    protected JRecipe clone() {
        try {
            return (JRecipe)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

