/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.devtech.arrp.json.recipe.JStackedResult;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;

public class JResult {
    public static final Codec<JResult> OBJECT_CODEC = RecordCodecBuilder.create(i -> i.group((App)Identifier.CODEC.fieldOf("item").forGetter(r -> r.item), (App)Codec.INT.optionalFieldOf("count").forGetter(r -> {
        Optional<Object> optional;
        if (r instanceof JStackedResult) {
            JStackedResult s = (JStackedResult)r;
            optional = Optional.ofNullable(s.getCount());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }), (App)DataComponentPatch.CODEC.optionalFieldOf("components").forGetter(r -> Optional.ofNullable(r.components))).apply((Applicative)i, (id, oc, comps) -> {
        JResult res = oc.isPresent() ? JResult.stackedResult(id, (Integer)oc.get()) : JResult.result(id);
        comps.ifPresent(res::components);
        return res;
    }));
    public static final Codec<JResult> CODEC = Codec.either((Codec)Identifier.CODEC, OBJECT_CODEC).xmap(e -> (JResult)e.map(JResult::result, x -> x), r -> {
        JStackedResult s;
        boolean hasCount = r instanceof JStackedResult && (s = (JStackedResult)r).getCount() != null && s.getCount() != 1;
        boolean hasComps = r.components != null && !r.components.isEmpty();
        return !hasCount && !hasComps ? Either.left((Object)r.item) : Either.right((Object)r);
    });
    protected final Identifier item;
    protected DataComponentPatch components;

    JResult(Identifier id) {
        this.item = id;
    }

    public JResult(Identifier item, DataComponentPatch components) {
        this.item = item;
        this.components = components;
    }

    public static JResult item(Item item) {
        return JResult.result(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static JResult result(Identifier id) {
        return new JResult(id);
    }

    public static JStackedResult itemStack(Item item, int count) {
        return JResult.stackedResult(BuiltInRegistries.ITEM.getKey((Object)item), count);
    }

    public static JStackedResult stackedResult(Identifier id, int count) {
        JStackedResult stackedResult = new JStackedResult(id);
        stackedResult.count = count;
        return stackedResult;
    }

    public JResult components(DataComponentPatch changes) {
        this.components = changes;
        return this;
    }

    public JResult components(Consumer<DataComponentPatch.Builder> build) {
        DataComponentPatch.Builder b = DataComponentPatch.builder();
        build.accept(b);
        this.components = b.build();
        return this;
    }

    public Identifier getItem() {
        return this.item;
    }

    public DataComponentPatch getComponents() {
        return this.components;
    }

    protected JResult clone() {
        try {
            return (JResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

