/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.tags;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.Identifier;

public class JTag {
    public static final Codec<JTag> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("replace").orElse((Object)false).forGetter(JTag::getReplace), (App)Codec.STRING.listOf().fieldOf("values").forGetter(JTag::getValues)).apply((Applicative)instance, JTag::new));
    private boolean replace;
    private List<String> values = new ArrayList<String>();

    public JTag() {
    }

    public JTag(boolean replace, List<String> values) {
        this.replace = replace;
        this.values = values;
    }

    public static JTag replacingTag() {
        return JTag.tag().replace();
    }

    public static JTag tag() {
        return new JTag();
    }

    public JTag replace() {
        return this.replace(true);
    }

    public JTag replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public JTag add(Identifier identifier) {
        this.values.add(identifier.toString());
        return this;
    }

    public JTag tag(Identifier tag) {
        this.values.add("#" + tag.getNamespace() + ":" + tag.getPath());
        return this;
    }

    public JTag clone() {
        try {
            return (JTag)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public boolean getReplace() {
        return this.replace;
    }

    public List<String> getValues() {
        return this.values;
    }
}

