/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.timeline;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JTimeline
implements Cloneable {
    public static final Codec<JTimeline> CODEC = new Codec<JTimeline>(){

        public <T> DataResult<T> encode(JTimeline timeline, DynamicOps<T> ops, T prefix) {
            JsonObject json = timeline.toJson();
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JTimeline, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Timeline definition must be an object");
            }
            try {
                return DataResult.success((Object)Pair.of((Object)JTimeline.fromJson(el.getAsJsonObject()), input));
            }
            catch (IllegalArgumentException e) {
                return DataResult.error(e::getMessage);
            }
        }
    };
    private Integer periodTicks;
    private final Map<String, Track> tracks = new LinkedHashMap<String, Track>();

    public static JTimeline fromJson(JsonObject json) {
        return new JTimeline().json(json);
    }

    public JTimeline json(JsonObject json) {
        this.tracks.clear();
        this.periodTicks = null;
        if (json == null) {
            return this;
        }
        if (json.has("period_ticks") && json.get("period_ticks").isJsonPrimitive() && json.get("period_ticks").getAsJsonPrimitive().isNumber()) {
            this.periodTicks = json.get("period_ticks").getAsInt();
        }
        if (json.has("tracks") && json.get("tracks").isJsonObject()) {
            JsonObject tracksObj = json.getAsJsonObject("tracks");
            for (String key : tracksObj.keySet()) {
                JsonElement value = tracksObj.get(key);
                if (value == null || !value.isJsonObject()) continue;
                this.tracks.put(key, Track.fromJson(value.getAsJsonObject()));
            }
        }
        return this;
    }

    public JTimeline clone() {
        JTimeline clone = new JTimeline();
        clone.periodTicks = this.periodTicks;
        for (Map.Entry<String, Track> entry : this.tracks.entrySet()) {
            String key = entry.getKey();
            Track value = entry.getValue();
            if (key == null || value == null) continue;
            clone.tracks.put(key, value.clone());
        }
        return clone;
    }

    public JTimeline period(Integer periodTicks) {
        this.periodTicks = periodTicks;
        return this;
    }

    public JTimeline period(int periodTicks) {
        this.periodTicks = periodTicks;
        return this;
    }

    public JTimeline tracks(Map<String, Track> tracks) {
        this.tracks.clear();
        if (tracks != null) {
            for (Map.Entry<String, Track> entry : tracks.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                this.tracks.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return this;
    }

    public JTimeline track(String attributeId, Track track) {
        if (attributeId != null && track != null) {
            this.tracks.put(attributeId, track.clone());
        }
        return this;
    }

    public Track getOrCreateTrack(String attributeId) {
        return this.tracks.computeIfAbsent(attributeId, k -> new Track());
    }

    public Integer getPeriodTicks() {
        return this.periodTicks;
    }

    public Map<String, Track> getTracks() {
        return this.tracks;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.periodTicks != null) {
            jsonObject.addProperty("period_ticks", (Number)this.periodTicks);
        }
        if (!this.tracks.isEmpty()) {
            JsonObject tracksObj = new JsonObject();
            for (Map.Entry<String, Track> entry : this.tracks.entrySet()) {
                String key = entry.getKey();
                Track value = entry.getValue();
                if (key == null || value == null) continue;
                tracksObj.add(key, (JsonElement)value.toJson());
            }
            jsonObject.add("tracks", (JsonElement)tracksObj);
        }
        return jsonObject;
    }

    public static final class Track
    implements Cloneable {
        public static final Codec<Track> CODEC = new Codec<Track>(){

            public <T> DataResult<T> encode(Track track, DynamicOps<T> ops, T prefix) {
                JsonObject json = track.toJson();
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
            }

            public <T> DataResult<Pair<Track, T>> decode(DynamicOps<T> ops, T input) {
                JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
                if (!el.isJsonObject()) {
                    return DataResult.error(() -> "Timeline track must be an object");
                }
                try {
                    return DataResult.success((Object)Pair.of((Object)Track.fromJson(el.getAsJsonObject()), input));
                }
                catch (IllegalArgumentException e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
        private JsonElement ease;
        private String modifier;
        private final List<Keyframe> keyframes = new ArrayList<Keyframe>();

        public static Track fromJson(JsonObject json) {
            JsonElement easeEl;
            Track track = new Track();
            if (json.has("ease") && (easeEl = json.get("ease")) != null && !easeEl.isJsonNull()) {
                track.ease = easeEl.deepCopy();
            }
            if (json.has("modifier") && json.get("modifier").isJsonPrimitive()) {
                track.modifier = json.get("modifier").getAsString();
            }
            if (!json.has("keyframes") || !json.get("keyframes").isJsonArray()) {
                throw new IllegalArgumentException("Timeline track missing 'keyframes' array");
            }
            JsonArray arr = json.getAsJsonArray("keyframes");
            for (JsonElement element : arr) {
                if (element == null || !element.isJsonObject()) continue;
                track.keyframes.add(Keyframe.fromJson(element.getAsJsonObject()));
            }
            return track;
        }

        public Track clone() {
            Track clone = new Track();
            clone.ease = this.ease == null ? null : this.ease.deepCopy();
            clone.modifier = this.modifier;
            for (Keyframe kf : this.keyframes) {
                if (kf == null) continue;
                clone.keyframes.add(kf.clone());
            }
            return clone;
        }

        public Track ease(JsonElement ease) {
            this.ease = ease == null ? null : ease.deepCopy();
            return this;
        }

        public Track ease(String easeName) {
            this.ease = easeName == null ? null : JsonParser.parseString((String)("\"" + easeName + "\""));
            return this;
        }

        public Track modifier(String modifier) {
            this.modifier = modifier;
            return this;
        }

        public Track keyframes(List<Keyframe> frames) {
            this.keyframes.clear();
            if (frames != null) {
                for (Keyframe frame : frames) {
                    if (frame == null) continue;
                    this.keyframes.add(frame.clone());
                }
            }
            return this;
        }

        public Track addKeyframe(Keyframe frame) {
            if (frame != null) {
                this.keyframes.add(frame.clone());
            }
            return this;
        }

        public static Track boolToggle(String modifier, int onTick, int offTick, boolean startValue, boolean endValue) {
            Track t = new Track().modifier(modifier);
            t.addKeyframe(new Keyframe(onTick, (JsonElement)new JsonPrimitive(Boolean.valueOf(startValue))));
            t.addKeyframe(new Keyframe(offTick, (JsonElement)new JsonPrimitive(Boolean.valueOf(endValue))));
            return t;
        }

        public static Track numericCurve(String modifier, float ... tickValuePairs) {
            Track t = new Track().modifier(modifier).ease("constant");
            if (tickValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("pairs needed");
            }
            for (int i = 0; i < tickValuePairs.length; i += 2) {
                int tick = (int)tickValuePairs[i];
                float value = tickValuePairs[i + 1];
                t.addKeyframe(new Keyframe(tick, (JsonElement)new JsonPrimitive((Number)Float.valueOf(value))));
            }
            return t;
        }

        public JsonElement getEase() {
            return this.ease;
        }

        public String getModifier() {
            return this.modifier;
        }

        public List<Keyframe> getKeyframes() {
            return this.keyframes;
        }

        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            if (this.ease != null) {
                obj.add("ease", this.ease.deepCopy());
            }
            if (this.modifier != null) {
                obj.addProperty("modifier", this.modifier);
            }
            JsonArray keyframesArr = new JsonArray();
            for (Keyframe kf : this.keyframes) {
                keyframesArr.add((JsonElement)kf.toJson());
            }
            obj.add("keyframes", (JsonElement)keyframesArr);
            return obj;
        }
    }

    public static final class Keyframe
    implements Cloneable {
        public static final Codec<Keyframe> CODEC = new Codec<Keyframe>(){

            public <T> DataResult<T> encode(Keyframe keyframe, DynamicOps<T> ops, T prefix) {
                JsonObject json = keyframe.toJson();
                return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
            }

            public <T> DataResult<Pair<Keyframe, T>> decode(DynamicOps<T> ops, T input) {
                JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
                if (!el.isJsonObject()) {
                    return DataResult.error(() -> "Timeline keyframe must be an object");
                }
                try {
                    return DataResult.success((Object)Pair.of((Object)Keyframe.fromJson(el.getAsJsonObject()), input));
                }
                catch (IllegalArgumentException e) {
                    return DataResult.error(e::getMessage);
                }
            }
        };
        private final int ticks;
        private final JsonElement value;

        public Keyframe(int ticks, JsonElement value) {
            if (value == null || value.isJsonNull()) {
                throw new IllegalArgumentException("Timeline keyframe missing 'value'");
            }
            this.ticks = ticks;
            this.value = value.deepCopy();
        }

        public static Keyframe fromJson(JsonObject json) {
            if (!(json.has("ticks") && json.get("ticks").isJsonPrimitive() && json.get("ticks").getAsJsonPrimitive().isNumber())) {
                throw new IllegalArgumentException("Timeline keyframe missing numeric 'ticks'");
            }
            if (!json.has("value")) {
                throw new IllegalArgumentException("Timeline keyframe missing 'value'");
            }
            int ticks = json.get("ticks").getAsInt();
            JsonElement value = json.get("value");
            return new Keyframe(ticks, value);
        }

        public int getTicks() {
            return this.ticks;
        }

        public JsonElement getValue() {
            return this.value;
        }

        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("ticks", (Number)this.ticks);
            obj.add("value", this.value.deepCopy());
            return obj;
        }

        public Keyframe clone() {
            try {
                Keyframe clone = (Keyframe)super.clone();
                return new Keyframe(this.ticks, this.value.deepCopy());
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e);
            }
        }
    }
}

