/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.devtech.arrp.json.worldgen.JAttributeValue;
import net.minecraft.util.ExtraCodecs;

public class JBiome {
    public static final Codec<JBiome> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("has_precipitation").forGetter(JBiome::hasPrecipitation), (App)Codec.FLOAT.fieldOf("temperature").forGetter(JBiome::temperature), (App)Codec.STRING.fieldOf("temperature_modifier").forGetter(JBiome::temperatureModifier), (App)Codec.FLOAT.fieldOf("downfall").forGetter(JBiome::downfall), (App)Effects.CODEC.fieldOf("effects").forGetter(JBiome::effects), (App)Codec.unboundedMap((Codec)Codec.STRING, JAttributeValue.CODEC).optionalFieldOf("attributes", Collections.emptyMap()).forGetter(b -> b.attributes == null ? Collections.emptyMap() : b.attributes), (App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability").forGetter(b -> {
        if (b.spawnSettings == null) {
            return Optional.empty();
        }
        Float prob = b.spawnSettings.getCreatureSpawnProbability();
        return prob == null ? Optional.empty() : Optional.of(prob);
    }), (App)Codec.unboundedMap((Codec)Codec.STRING, SpawnSettings.SpawnCost.CODEC).optionalFieldOf("spawn_costs").forGetter(b -> Optional.of(b.spawnSettings == null ? Collections.emptyMap() : b.spawnSettings.getSpawnCosts())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SpawnSettings.SpawnerData.CODEC.listOf()).optionalFieldOf("spawners").forGetter(b -> Optional.of(b.spawnSettings == null ? Collections.emptyMap() : b.spawnSettings.getSpawners())), (App)Codec.STRING.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(b -> {
        if (b.generation == null) {
            return Collections.emptyList();
        }
        return b.generation.getCarvers();
    }), (App)Codec.STRING.listOf().listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(b -> {
        if (b.generation == null) {
            return Collections.emptyList();
        }
        return b.generation.getFeaturesByStep();
    })).apply((Applicative)instance, (precip, temp, tempMod, downfall, effects, attrs, spawnProbOpt, spawnCostsOpt, spawnersOpt, carvers, featuresSteps) -> {
        boolean hasAnySpawn;
        JBiome biome = new JBiome();
        biome.hasPrecipitation((boolean)precip);
        biome.temperature(temp.floatValue());
        biome.temperatureModifier((String)tempMod);
        biome.downfall(downfall.floatValue());
        biome.effects((Effects)effects);
        biome.attributes((Map<String, JAttributeValue>)attrs);
        boolean bl = hasAnySpawn = spawnProbOpt.isPresent() || spawnCostsOpt.isPresent() || spawnersOpt.isPresent();
        if (hasAnySpawn) {
            Map spawners;
            SpawnSettings s = new SpawnSettings();
            spawnProbOpt.ifPresent(s::setCreatureSpawnProbability);
            Map spawnCosts = spawnCostsOpt.orElseGet(Collections::emptyMap);
            if (!spawnCosts.isEmpty()) {
                s.spawnCosts.putAll(spawnCosts);
            }
            if (!(spawners = spawnersOpt.orElseGet(Collections::emptyMap)).isEmpty()) {
                s.spawners.putAll(spawners);
            }
            biome.spawnSettings(s);
        }
        if (!carvers.isEmpty() || !featuresSteps.isEmpty()) {
            Generation g = new Generation();
            for (String c : carvers) {
                g.addCarver(c);
            }
            for (int step = 0; step < featuresSteps.size(); ++step) {
                for (String feat : (List)featuresSteps.get(step)) {
                    g.addFeature(step, feat);
                }
            }
            biome.generation(g);
        }
        return biome;
    }));
    private Boolean hasPrecipitation;
    private Float temperature;
    private String temperatureModifier = "none";
    private Float downfall;
    private Effects effects = null;
    private Map<String, JAttributeValue> attributes;
    private SpawnSettings spawnSettings = new SpawnSettings();
    private Generation generation;

    public JBiome() {
        this.attributes = new HashMap<String, JAttributeValue>();
        this.generation = new Generation();
    }

    public static JBiome biome() {
        return new JBiome();
    }

    public static JBiome empty() {
        return new JBiome();
    }

    private Boolean hasPrecipitation() {
        return this.hasPrecipitation;
    }

    private float temperature() {
        return this.temperature.floatValue();
    }

    private String temperatureModifier() {
        return this.temperatureModifier;
    }

    private float downfall() {
        return this.downfall.floatValue();
    }

    private Effects effects() {
        return this.effects;
    }

    private Optional<Map<String, JAttributeValue>> attributesOptional() {
        return Optional.ofNullable(this.attributes);
    }

    private Optional<SpawnSettings> spawnSettingsOptional() {
        return Optional.ofNullable(this.spawnSettings);
    }

    private Optional<Generation> generationOptional() {
        return Optional.ofNullable(this.generation);
    }

    public JBiome hasPrecipitation(boolean has) {
        this.hasPrecipitation = has;
        return this;
    }

    public JBiome temperature(float temperature) {
        this.temperature = Float.valueOf(temperature);
        return this;
    }

    public JBiome temperatureModifier(String modifier) {
        this.temperatureModifier = modifier;
        return this;
    }

    public JBiome downfall(float downfall) {
        this.downfall = Float.valueOf(downfall);
        return this;
    }

    public JBiome effects(Effects effects) {
        this.effects = this.effects == null ? new Effects() : effects;
        return this;
    }

    public JBiome attributes(Map<String, JAttributeValue> attributes) {
        this.attributes = attributes;
        return this;
    }

    public JBiome spawnSettings(SpawnSettings spawnSettings) {
        this.spawnSettings = this.spawnSettings == null ? new SpawnSettings() : spawnSettings;
        return this;
    }

    public JBiome generation(Generation generation) {
        this.generation = this.generation == null ? new Generation() : generation;
        return this;
    }

    private Effects ensureEffects() {
        if (this.effects == null) {
            this.effects = new Effects();
        }
        return this.effects;
    }

    private Map<String, JAttributeValue> ensureAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, JAttributeValue>();
        }
        return this.attributes;
    }

    public JBiome attribute(String id, String value) {
        this.ensureAttributes().put(id, JAttributeValue.ofString(value));
        return this;
    }

    public JBiome attribute(String id, Number value) {
        this.ensureAttributes().put(id, JAttributeValue.ofFloat(value.floatValue()));
        return this;
    }

    public JBiome attribute(String id, boolean value) {
        this.ensureAttributes().put(id, JAttributeValue.ofBoolean(value));
        return this;
    }

    private SpawnSettings ensureSpawnSettings() {
        if (this.spawnSettings == null) {
            this.spawnSettings = new SpawnSettings();
        }
        return this.spawnSettings;
    }

    public JBiome spawnProbability(float probability) {
        this.ensureSpawnSettings().setCreatureSpawnProbability(probability);
        return this;
    }

    public JBiome spawnCost(String entityId, double energyBudget, double charge) {
        this.ensureSpawnSettings().addSpawnCost(entityId, energyBudget, charge);
        return this;
    }

    public JBiome spawner(String category, String entityId, int weight, int minCount, int maxCount) {
        this.ensureSpawnSettings().addSpawner(category, entityId, weight, minCount, maxCount);
        return this;
    }

    public static class SpawnSettings {
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability").forGetter(s -> Optional.ofNullable(s.creatureSpawnProbability)), (App)Codec.unboundedMap((Codec)Codec.STRING, SpawnCost.CODEC).optionalFieldOf("spawn_costs", Collections.emptyMap()).forGetter(s -> s.spawnCosts == null ? Collections.emptyMap() : s.spawnCosts), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SpawnerData.CODEC.listOf()).optionalFieldOf("spawners", Collections.emptyMap()).forGetter(s -> s.spawners == null ? Collections.emptyMap() : s.spawners)).apply((Applicative)instance, (probOpt, spawnCosts, spawners) -> {
            SpawnSettings s = new SpawnSettings();
            probOpt.ifPresent(s::setCreatureSpawnProbability);
            if (!spawnCosts.isEmpty()) {
                s.spawnCosts.putAll((Map<String, SpawnCost>)spawnCosts);
            }
            if (!spawners.isEmpty()) {
                s.spawners.putAll((Map<String, List<SpawnerData>>)spawners);
            }
            return s;
        }));
        private Float creatureSpawnProbability;
        private Map<String, SpawnCost> spawnCosts = new LinkedHashMap<String, SpawnCost>();
        private Map<String, List<SpawnerData>> spawners = new LinkedHashMap<String, List<SpawnerData>>();

        public Float getCreatureSpawnProbability() {
            return this.creatureSpawnProbability;
        }

        public SpawnSettings setCreatureSpawnProbability(float probability) {
            this.creatureSpawnProbability = Float.valueOf(probability);
            return this;
        }

        public Map<String, SpawnCost> getSpawnCosts() {
            return Collections.unmodifiableMap(this.spawnCosts);
        }

        public Map<String, List<SpawnerData>> getSpawners() {
            return Collections.unmodifiableMap(this.spawners);
        }

        public SpawnSettings addSpawnCost(String entityId, double energyBudget, double charge) {
            if (entityId != null) {
                this.spawnCosts.put(entityId, new SpawnCost(energyBudget, charge));
            }
            return this;
        }

        public SpawnSettings addSpawner(String category, String entityId, int weight, int minCount, int maxCount) {
            if (category == null || entityId == null) {
                return this;
            }
            this.spawners.computeIfAbsent(category, k -> new ArrayList()).add(new SpawnerData(entityId, weight, minCount, maxCount));
            return this;
        }

        public record SpawnCost(double energyBudget, double charge) {
            public static final Codec<SpawnCost> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(c -> c.energyBudget), (App)Codec.DOUBLE.fieldOf("charge").forGetter(c -> c.charge)).apply((Applicative)instance, SpawnCost::new));
        }

        public record SpawnerData(String type, int weight, int minCount, int maxCount) {
            public static final Codec<SpawnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(d -> d.type), (App)Codec.INT.fieldOf("weight").forGetter(d -> d.weight), (App)Codec.INT.fieldOf("minCount").forGetter(d -> d.minCount), (App)Codec.INT.fieldOf("maxCount").forGetter(d -> d.maxCount)).apply((Applicative)instance, SpawnerData::new));
        }
    }

    public static class Effects {
        public static final Codec<Effects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.STRING_RGB_COLOR.fieldOf("water_color").forGetter(e -> e.waterColor), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("grass_color").forGetter(e -> e.grassColor), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("foliage_color").forGetter(e -> e.foliageColor), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("dry_foliage_color").forGetter(e -> e.dryFoliageColor), (App)Codec.STRING.optionalFieldOf("grass_color_modifier").forGetter(e -> Optional.ofNullable(e.grassColorModifier))).apply((Applicative)instance, (water, grass, foliage, dryFoliage, modifier) -> {
            Effects e = new Effects();
            e.waterColor((int)water);
            grass.ifPresent(e::grassColor);
            foliage.ifPresent(e::foliageColor);
            dryFoliage.ifPresent(e::dryFoliageColor);
            modifier.ifPresent(e::grassColorModifier);
            return e;
        }));
        private int waterColor;
        private Optional<Integer> grassColor = Optional.empty();
        private Optional<Integer> foliageColor = Optional.empty();
        private Optional<Integer> dryFoliageColor = Optional.empty();
        private String grassColorModifier;

        public Effects waterColor(int color) {
            this.waterColor = color;
            return this;
        }

        public Effects grassColor(int color) {
            this.grassColor = Optional.of(color);
            return this;
        }

        public Effects foliageColor(int color) {
            this.foliageColor = Optional.of(color);
            return this;
        }

        public Effects dryFoliageColor(int color) {
            this.dryFoliageColor = Optional.of(color);
            return this;
        }

        public Effects grassColorModifier(String modifier) {
            this.grassColorModifier = modifier;
            return this;
        }
    }

    public static class Generation {
        public static final Codec<Generation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf("carvers", Collections.emptyList()).forGetter(g -> g.carvers == null ? Collections.emptyList() : g.carvers), (App)Codec.STRING.listOf().listOf().optionalFieldOf("features", Collections.emptyList()).forGetter(g -> g.features == null ? Collections.emptyList() : g.features)).apply((Applicative)instance, (carvers, features) -> {
            Generation g = new Generation();
            g.carvers = new ArrayList<String>((Collection<String>)carvers);
            g.features = new ArrayList<List<String>>();
            for (List step : features) {
                g.features.add(new ArrayList(step));
            }
            return g;
        }));
        private List<String> carvers = new ArrayList<String>();
        private List<List<String>> features = new ArrayList<List<String>>();

        public Generation addCarver(String id) {
            if (id != null) {
                this.carvers.add(id);
            }
            return this;
        }

        private void ensureStep(int step) {
            while (this.features.size() <= step) {
                this.features.add(new ArrayList());
            }
        }

        public Generation addFeature(int step, String id) {
            if (id == null) {
                return this;
            }
            this.ensureStep(step);
            this.features.get(step).add(id);
            return this;
        }

        public List<String> getCarvers() {
            return Collections.unmodifiableList(this.carvers);
        }

        public List<List<String>> getFeaturesByStep() {
            if (this.features != null) {
                ArrayList<List<String>> copy = new ArrayList<List<String>>(this.features.size());
                for (List<String> step : this.features) {
                    copy.add(Collections.unmodifiableList(step));
                }
                return Collections.unmodifiableList(copy);
            }
            return Collections.emptyList();
        }
    }
}

