/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.dimension;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;

public class JDimension
implements Cloneable {
    public static final Codec<JDimension> CODEC = new Codec<JDimension>(){

        public <T> DataResult<T> encode(JDimension dimension, DynamicOps<T> ops, T prefix) {
            JsonObject json = dimension.toJson();
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JDimension, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Dimension definition must be an object");
            }
            return DataResult.success((Object)Pair.of((Object)JDimension.fromJson(el.getAsJsonObject()), input));
        }
    };
    private String type;
    private JsonObject generator;
    private final JsonObject extra = new JsonObject();

    public static JDimension dimension() {
        return new JDimension();
    }

    public static JDimension fromJson(JsonObject json) {
        return new JDimension().json(json);
    }

    public JDimension json(JsonObject json) {
        this.type = null;
        this.generator = null;
        this.extra.entrySet().clear();
        if (json == null) {
            return this;
        }
        if (json.has("type") && json.get("type").isJsonPrimitive()) {
            this.type = json.get("type").getAsString();
        }
        if (json.has("generator") && json.get("generator").isJsonObject()) {
            this.generator = json.getAsJsonObject("generator").deepCopy();
        }
        for (String key : json.keySet()) {
            JsonElement value;
            if (JDimension.isKnown(key) || (value = json.get(key)) == null) continue;
            this.extra.add(key, value.deepCopy());
        }
        return this;
    }

    public JDimension type(String type) {
        this.type = type;
        return this;
    }

    public JDimension generator(JsonObject generator) {
        this.generator = generator == null ? null : generator.deepCopy();
        return this;
    }

    public JDimension extra(String key, JsonElement value) {
        if (key != null && value != null && !JDimension.isKnown(key)) {
            this.extra.add(key, value.deepCopy());
        }
        return this;
    }

    public JDimension noiseGenerator(String settingsId) {
        JsonObject gen = this.generator == null ? new JsonObject() : this.generator.deepCopy();
        gen.addProperty("type", "minecraft:noise");
        gen.addProperty("settings", settingsId);
        this.generator = gen;
        return this;
    }

    public JDimension fixedBiome(String biomeId) {
        JsonObject biomeSource = new JsonObject();
        biomeSource.addProperty("type", "minecraft:fixed");
        biomeSource.addProperty("biome", biomeId);
        JsonObject gen = this.generator == null ? new JsonObject() : this.generator.deepCopy();
        gen.add("biome_source", (JsonElement)biomeSource);
        this.generator = gen;
        return this;
    }

    public JsonObject toJson() {
        JsonObject out = new JsonObject();
        if (this.type != null) {
            out.addProperty("type", this.type);
        }
        if (this.generator != null) {
            out.add("generator", (JsonElement)this.generator.deepCopy());
        }
        for (String key : this.extra.keySet()) {
            JsonElement value = this.extra.get(key);
            if (value == null) continue;
            out.add(key, value.deepCopy());
        }
        return out;
    }

    public JDimension clone() {
        try {
            JDimension clone = (JDimension)super.clone();
            clone.generator = this.generator == null ? null : this.generator.deepCopy();
            clone.extra.entrySet().clear();
            for (String key : this.extra.keySet()) {
                JsonElement value = this.extra.get(key);
                if (value == null) continue;
                clone.extra.add(key, value.deepCopy());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static boolean isKnown(String key) {
        return "type".equals(key) || "generator".equals(key);
    }
}

