/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.worldgen.structure;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;

public class JStructure
implements Cloneable {
    public static final Codec<JStructure> CODEC = new Codec<JStructure>(){

        public <T> DataResult<T> encode(JStructure structure, DynamicOps<T> ops, T prefix) {
            JsonObject json = structure.toJson();
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json).convert(ops).getValue());
        }

        public <T> DataResult<Pair<JStructure, T>> decode(DynamicOps<T> ops, T input) {
            JsonElement el = (JsonElement)new Dynamic(ops, input).convert((DynamicOps)JsonOps.INSTANCE).getValue();
            if (!el.isJsonObject()) {
                return DataResult.error(() -> "Structure must be an object");
            }
            return DataResult.success((Object)Pair.of((Object)JStructure.fromJson(el.getAsJsonObject()), input));
        }
    };
    private String type;
    private JsonElement biomes;
    private String step;
    private JsonObject spawnOverrides;
    private JsonObject settings;
    private final JsonObject extra = new JsonObject();

    public static JStructure structure() {
        return new JStructure();
    }

    public static JStructure fromJson(JsonObject json) {
        return new JStructure().json(json);
    }

    public JStructure json(JsonObject json) {
        this.type = null;
        this.biomes = null;
        this.step = null;
        this.spawnOverrides = null;
        this.settings = null;
        this.extra.entrySet().clear();
        if (json == null) {
            return this;
        }
        if (json.has("type") && json.get("type").isJsonPrimitive()) {
            this.type = json.get("type").getAsString();
        }
        if (json.has("biomes")) {
            this.biomes = json.get("biomes").deepCopy();
        }
        if (json.has("step") && json.get("step").isJsonPrimitive()) {
            this.step = json.get("step").getAsString();
        }
        if (json.has("spawn_overrides") && json.get("spawn_overrides").isJsonObject()) {
            this.spawnOverrides = json.getAsJsonObject("spawn_overrides").deepCopy();
        }
        if (json.has("settings") && json.get("settings").isJsonObject()) {
            this.settings = json.getAsJsonObject("settings").deepCopy();
        }
        for (String key : json.keySet()) {
            JsonElement val;
            if (JStructure.isKnown(key) || (val = json.get(key)) == null) continue;
            this.extra.add(key, val.deepCopy());
        }
        return this;
    }

    public JStructure type(String type) {
        this.type = type;
        return this;
    }

    public JStructure biomes(JsonElement biomes) {
        this.biomes = biomes == null ? null : biomes.deepCopy();
        return this;
    }

    public JStructure biomesId(String id) {
        this.biomes = id == null ? null : new JsonPrimitive(id);
        return this;
    }

    public JStructure biomesTag(String tag) {
        if (tag == null) {
            this.biomes = null;
        } else {
            if (!((String)tag).startsWith("#")) {
                tag = "#" + (String)tag;
            }
            this.biomes = new JsonPrimitive((String)tag);
        }
        return this;
    }

    public JStructure step(String step) {
        this.step = step;
        return this;
    }

    public JStructure spawnOverrides(JsonObject overrides) {
        this.spawnOverrides = overrides == null ? null : overrides.deepCopy();
        return this;
    }

    public JStructure settings(JsonObject settings) {
        this.settings = settings == null ? null : settings.deepCopy();
        return this;
    }

    public JStructure extra(String key, JsonElement value) {
        if (key != null && value != null && !JStructure.isKnown(key)) {
            this.extra.add(key, value.deepCopy());
        }
        return this;
    }

    public static JStructure jigsaw(String startPool) {
        JStructure s = JStructure.structure().type("minecraft:jigsaw");
        JsonObject settings = new JsonObject();
        settings.addProperty("start_pool", startPool);
        s.settings(settings);
        return s;
    }

    private JsonObject ensureSettings() {
        if (this.settings == null) {
            this.settings = new JsonObject();
        }
        return this.settings;
    }

    public JStructure size(int size) {
        this.ensureSettings().addProperty("size", (Number)size);
        return this;
    }

    public JStructure maxDistanceFromCenter(int v) {
        this.ensureSettings().addProperty("max_distance_from_center", (Number)v);
        return this;
    }

    public JStructure startHeightInt(int v) {
        this.ensureSettings().addProperty("start_height", (Number)v);
        return this;
    }

    public JStructure useExpansionHack(boolean v) {
        this.ensureSettings().addProperty("use_expansion_hack", Boolean.valueOf(v));
        return this;
    }

    public JsonObject toJson() {
        JsonObject out = new JsonObject();
        if (this.type != null) {
            out.addProperty("type", this.type);
        }
        if (this.biomes != null) {
            out.add("biomes", this.biomes.deepCopy());
        }
        if (this.step != null) {
            out.addProperty("step", this.step);
        }
        if (this.spawnOverrides != null) {
            out.add("spawn_overrides", (JsonElement)this.spawnOverrides.deepCopy());
        }
        if (this.settings != null) {
            out.add("settings", (JsonElement)this.settings.deepCopy());
        }
        for (String key : this.extra.keySet()) {
            JsonElement val = this.extra.get(key);
            if (val == null) continue;
            out.add(key, val.deepCopy());
        }
        return out;
    }

    public JStructure clone() {
        try {
            JStructure clone = (JStructure)super.clone();
            clone.biomes = this.biomes == null ? null : this.biomes.deepCopy();
            clone.spawnOverrides = this.spawnOverrides == null ? null : this.spawnOverrides.deepCopy();
            clone.settings = this.settings == null ? null : this.settings.deepCopy();
            clone.extra.entrySet().clear();
            for (String key : this.extra.keySet()) {
                JsonElement val = this.extra.get(key);
                if (val == null) continue;
                clone.extra.add(key, val.deepCopy());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static boolean isKnown(String key) {
        return "type".equals(key) || "biomes".equals(key) || "step".equals(key) || "spawn_overrides".equals(key) || "settings".equals(key);
    }
}

